#ifndef RANSAC_H
#define RANSAC_H

#include <stdlib.h>
#include <math.h>

#include <QPointF>
#include <QList>
#include <QFile>
#include <QTime>

#include "opencv/cv.h"
#include "opencv/cvtypes.h"

class LinearModel
{
public:
    LinearModel() : mSlope(0), mIntercept(0) {};
    LinearModel(qreal _slope, qreal _intercept) : mSlope(_slope), mIntercept(_intercept) {};
    qreal mSlope;
    qreal mIntercept;
};

class CRansacLinear
{
public:

    CRansacLinear(): mBestError(INT_MAX) {
        qsrand(QTime::currentTime().msec());
    };

    void setObservationSet(const QList<QPointF>& observationSet) {
        dump(observationSet);
        mObservationSet = observationSet;
    }

    void setModel(LinearModel& model) {
        mBestModel.mIntercept = model.mIntercept;
        mBestModel.mSlope     = model.mSlope;
    }

    void setTreshold(const float treshold) {
        mTreshold = treshold;
    }

    void setIterations(const int Iterations) {
        mIterations = Iterations;
    }

    void setRequiredInliers(const int requiredInliers) {
        mRequiredInliers = requiredInliers;
    }

    bool getBestModel(LinearModel& bestLinearModel);

    void dump(const QList<QPointF>& pointListF);

private:
    QList<QPointF>  mObservationSet;
    QList<QPointF>  mBestConsensusSet;
    LinearModel     mBestModel;
    int             mRequiredInliers;
    int             mIterations;
    qreal           mBestError;
    qreal           mTreshold;

    bool            isMember(const QPointF& point, const QList<QPointF>& maybeInliers) const;
    bool            fitsModel(const QPointF& point, const LinearModel& model) const;

    LinearModel     getModel(const QPointF& p1, const QPointF& p2) const;
    LinearModel     getModel(const QList<QPointF>& observation) const;

    QList<QPointF>  getMaybeInliers() const;

    int             getModelError(const QList<QPointF>& pointList, const LinearModel& model) const;
    qreal           getDistance(const QPointF& p, const LinearModel& model) const;
};

#endif // RANSAC_H
